
//Program to determine bus impedance matrix of a power system of any size using building algorithm//
//This program needs user input. Sample problem with user input and output is available in the result file//
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
linedata=input('enter the line data values in the order of starting bus,ending bus,resistance and reactance:') //note:enter 0 for reference bus
sb=linedata(:,1)
eb=linedata(:,2)
z=linedata(:,3)+linedata(:,4)*%i   //impedance z=R+jX
zbus=[];
check=[];
for i=1:length(sb)
    m=sb(i);
    n=eb(i);
    mn=min(m,n);
    nm=max(m,n);
    ncheck=length(find(check==nm));   //Variable used for checking whether bus nm is already existing
    mcheck=length(find(check==mn));   //Variable used for checking whether bus mn is already existing
    [rows columns]=size(zbus);
//Condition for connection of line between reference bus and new bus
    if mn==0 & ncheck==0 
        zbus=[zbus zeros(rows,1);zeros(1,rows) z(i)];
        check=[check nm];
//Condition for connection of line between existing bus and new bus
         else if mcheck>0 & ncheck==0
            zbus=[zbus zbus(:,mn);zbus(mn,:) zbus(mn,mn)+z(i)];
            check=[check nm];
//Condition for connection of line between reference bus and existing bus
            elseif mn==0 & ncheck>0
            zbus=[zbus zbus(:,nm);zbus(nm,:) zbus(nm,nm)+z(i)];
            //Modifying Z bus size using Kron's reduction tehnique
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                    zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1));
                end
            end
            zbus=zbusn
//Condition for connection of line between two existing buses
        elseif mcheck>0 & ncheck>0
            zbus=[zbus zbus(:,nm)-zbus(:,mn);zbus(nm,:)-zbus(mn,:),z(i)+zbus(mn,nm)+zbus(nm,nm)-2*zbus(nm,mn)];
            //Modifying Z bus size using Kron's reduction tehnique
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                   zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1)); 
               end
           end
           zbus=zbusn;
       end
   end
end
disp(zbus,'The bus impedance matrix is:');


//SAMPLE INPUT:

//enter the line data values in the order of starting bus,ending bus,resistance and reactance:[0 1 0 0.5;1 2 0 0.2;2 3 0 0.1;3 0 0 0.4]
 
 //OUTPUT:
 //The bus impedance matrix is:   
 
//    0.2916667i    0.2083333i    0.1666667i  
//    0.2083333i    0.2916667i    0.2333333i  
//    0.1666667i    0.2333333i    0.2666667i

